<?php 
   /**
    *
    * copyright (c) 2013-2023 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    */

    include "../include/includeBaseComponenti.php";
    include "../../../template/stile.php";
    include "classi/InvitoAzione.php";
    
    if(isset($_GET["id"])) {
        $invitoAzione = new InvitoAzione($geecomDb, filter_input(INPUT_GET, "id",FILTER_SANITIZE_NUMBER_INT));
        $invitoAzione->caricaDatiDalDatabase();
    }
    
    if(isset($_GET["status"])) {
        $status = filter_input(INPUT_GET,"status",FILTER_SANITIZE_NUMBER_INT);
    }
    else {
        $status = 0;
    }
?>
<!doctype html>
<html lang="en">
    <head>
        <!-- Required meta tags -->
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

        <?php
            include "../include/cssBaseComponenti.php";
        ?>
        <title>Geecom CMS - Creazione invito all'azione</title>
    </head>
    <body>
    
        <header>
            <?php 
                include "../../include/barraSuperiore.php";

                include "../../include/header.php";

                include "../../include/barraMenu.php";
            ?>
        </header>

        <main role="main" class="bg-light" id="main">
            <div class="container-fluid">
                <div class="row py-4">
                    <?php 
                        if($status==200) {
                            echo"<div class=\"col-12\">
                                    <div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                        Invito all'azione creato
                                        <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                              <span aria-hidden=\"true\">&times;</span>
                                        </button>
                                    </div>
                                </div>";
                        }
                        else if($status==210) {
                            echo"<div class=\"col-12\">
                                    <div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                        Invito all'azione duplicato, modificalo per non avere due contenuti identici
                                        <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                              <span aria-hidden=\"true\">&times;</span>
                                        </button>
                                    </div>
                                </div>";
                        }
                        else if($status==250) {
                            echo"<div class=\"col-12\">
                                    <div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                        Invito all'azione modificato
                                        <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                              <span aria-hidden=\"true\">&times;</span>
                                        </button>
                                    </div>
                                </div>";
                        }
                    ?>
                    <div class="col-lg-8">
                        <form name="formComponente" action="controller/controllerComponente.php" method="post">
                            <input type="text" class="d-none" name="operazione" value="<?php echo((isset($invitoAzione) ? "modifica" : "crea")); ?>">
                            <input type="text" class="d-none" name="id" value="<?php echo((isset($invitoAzione) ? $invitoAzione->getId() : "0")); ?>">
                                
                            <div class="form-row justify-content-between mb-3">
                                <div class="col-auto d-flex">
                                    <nav aria-label="breadcrumb" class="align-self-center">
                                        <ol class="breadcrumb p-0 mb-1 mb-md-0 bg-transparent">
                                            <li class="breadcrumb-item"><a href="../../home.php">Home</a></li>
                                            <li class="breadcrumb-item"><a href="#" data-toggle="modal" data-target="#menu-componenti">Componenti</a></li>
                                            <li class="breadcrumb-item"><a href="index.php">Invito all'azione</a></li>
                                            <li class="breadcrumb-item active" aria-current="page"><?php echo((isset($invitoAzione) ? $invitoAzione->getId() : "0")? $invitoAzione->getNome() : "Nuovo invito all'azione")?></li>
                                        </ol>
                                    </nav>
                                </div>
                                <div class="col-auto text-right">
                                    <a class="btn btn-outline-primary" href="index.php"><i class="fas fa-arrow-left mr-2"></i>Torna all'elenco</a>
                                </div>
                            </div>
                            <div class="card mb-4 box-shadow-lite">
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-md-6">
                                            <label>Nome:</label>
                                            <input type="text" class="form-control" id="nomeSlider" name="nome" aria-describedby="nome Slider" value="<?php echo((isset($invitoAzione) ? $invitoAzione->getNome() : "")) ?>" placeholder="Nome occorrenza">
                                        </div>
                                        <div class="col-md-6 form-group">
                                            <label>Spazio occupato</label>
                                            <select class="form-control" name="spazioOccupato">
                                            <?php 
                                                foreach($arrayDimensioniColonna as $classe=>$descrizione) {
                                                    if(isset($invitoAzione) && $invitoAzione->getSpazioOccupato()==$classe) {
                                                        echo"<option value=\"$classe\" selected>$descrizione</option>";
                                                    }
                                                    else {
                                                        echo"<option value=\"$classe\">$descrizione</option>";
                                                    }
                                                }
                                            ?>
                                            </select>
                                            <small class="text-muted">Lo spazio orizzontale occupato dall'elemento</small>
                                        </div>

                                        <div class="col-md-6 form-group">
                                            <label for="">Altezza proporzionale</label>
                                            <select class="form-control" name="altezza">
                                                <?php 
                                                    foreach($arrayAltezze as $classe=>$descrizione) {
                                                        if(isset($invitoAzione) && $invitoAzione->getAltezza()==$classe) {
                                                            echo"<option value=\"$classe\" selected>$descrizione</option>";
                                                        }
                                                        else {
                                                            echo"<option value=\"$classe\">$descrizione</option>";
                                                        }
                                                    }
                                                ?>
                                            </select>
                                            <small class="form-text text-muted">Stabilisce l'altezza proporzionale occupata dall'invito all'azione rispetto alla viewport</small>
                                        </div>

                                        <div class="form-group col-12">
                                            <textarea class="tiny" name="testo"><?php echo(isset($invitoAzione) ? $invitoAzione->getTesto() : "") ?></textarea>
                                        </div>

                                        <div class="form-group col-md-6">
                                            <label for="titolo-articolo">Etichetta pulsante</label>
                                            <input  type="text" class="form-control" name="titoloPulsante" value="<?php echo((isset($invitoAzione)? $invitoAzione->getTitoloPulsante() : ""))?>" placeholder="Link">
                                        </div>

                                        <div class="form-group col-md-6">
                                            <label for="titolo-articolo">Stile pulsante</label>
                                            <input  type="text" class="form-control" name="stilePulsante" value="<?php echo((isset($invitoAzione)? $invitoAzione->getStilePulsante() : ""))?>" placeholder="Link">
                                        </div>

                                        <div class="form-group col-md-6">
                                            <label for="titolo-articolo">Link pulsante</label>
                                            <input  type="text" class="form-control" name="linkPulsante" value="<?php echo((isset($invitoAzione)? $invitoAzione->getLinkPulsante() : ""))?>" placeholder="Link pulsante">
                                        </div>

                                    </div>
                                    </form>
                                </div>
                                <div class="card-footer">
                                    <button type="button" class="btn btn-primary float-right" onclick="document.formComponente.submit()"><i class="fas fa-check"></i> Salva</button>
                                </div>
                            </div>
                        </form>
                    </div>
                    <div class="col-lg-4">
                        <div class="btn-group d-flex mb-3" role="group" aria-label="Basic example">
                            <button type="button" class="btn btn-primary w-100" onclick="document.formComponente.submit()"><i class="fas fa-check mr-2"></i>Salva</button>
                            <?php 
                                if(isset($elemento)) {
                            ?>
                                    <button type="button" class="btn btn-warning w-100" onclick="location.href='../../../controller/controllerContenuti.php?id=<?php echo $elemento->getId() ?>&operazione=duplicaElementoPortfolio';"><i class="far fa-clone mr-2"></i>Duplica</button>
                            <?php
                                }
                            ?>
                        </div>
                        <div class="card mb-3 rounded-0 accordion box-shadow-lite">
                            <div class="card-header collapsed" data-toggle="collapse" href="#ImmagineInEvidenza">
                                <a class="card-title">
                                    Immagine in evidenza
                                </a>
                            </div>
                            <div id="ImmagineInEvidenza" class="collapse show">
                                <div class="card-body">
                                    <div class="img-container">
                                        <div class="azioni">
                                            <div class="btn-group" role="group" aria-label="">
                                                <button onclick="eliminaImmagineOccorrenza()" type="button" class="btn btn-sm btn-light elimina" data-toggle="tooltip" data-placement="bottom" title="Rimuovi"><i class="far fa-trash-alt"></i></button>
                                            </div>
                                        </div>
                                        <img id="immagineElemento" class="img-fluid w-100 mb-3" src="../../../<?php echo((isset($invitoAzione) && $invitoAzione->getPercorsoImmagine()!="") ? $invitoAzione->getPercorsoImmagine() : "immagini/altro/segnaposto.png") ?>" alt="immagine attuale">
                                    </div>

                                    <button type="button" class="btn btn-outline-primary btn-block mb-3" onclick="apriPopupSelezioneImmagini()"><i class="far fa-image"></i> Scegli da immagini caricate</button>

                                    <form action="controller/controllerComponente.php" id="frmFileUpload-00" class="dropzone singolo-file" method="post" enctype="multipart/form-data">
                                        <div class="dz-message">
                                            <i class="fas fa-file-upload fa-2x mb-2"></i>
                                            <h5>Trascina o carica qui l'immagine</h5>
                                        </div>
                                        <div class="fallback">
                                            <input name="file" type="file" />
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </main>

        <?php
            include "../../include/footer.php";

            include "../include/modal/cambiaPassword.php";
            
            include "../include/modal/eliminaElemento.php";

            include "../../include/modal/modalMenuComponenti.php";

            include "../../include/modal/operazioneCompletata.php";
            
            include "../../include/modal/modalSelezionaFoto.php";

            include "../include/jsBaseComponenti.php";
        ?>

        <!-- Dropzone -->
        <script type="text/javascript" src="../../../plugins/dropzone/dropzone.js"></script>
        <script>
            $("#frmFileUpload-00").dropzone({
                acceptedFiles: ".jpeg,.jpg,.png,.webp,.gif,.svg",
                maxFiles: 1,
                addRemoveLinks: true,
                dictRemoveFile: "Rimuovi",
                success: function(file,response) {
                    document.getElementById("immagineElemento").src=response;
                    this.removeAllFiles();
                },
                params:{
                    operazione:"modificaImmagine",
                    id:<?php echo $invitoAzione->getId() ?>
                },
                maxfilesexceeded: function(file) {
                    this.removeAllFiles();
                    this.addFile(file);
                }
            })
            
            function eliminaImmagineOccorrenza() {
                $.ajax({
                    type:"GET",
                    url:"controller/controllerComponente.php",
                    data:{
                        operazione:"eliminaImmagineOccorrenza",
                        id:<?php echo $invitoAzione->getId() ?>
                    },
                    success:function(result) {
                        if(result=="ok") {
                            document.getElementById("immagineElemento").src="../../../immagini/altro/segnaposto.png";
                        }
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
            
            function apriPopupSelezioneImmagini() {
                $.ajax({
                    type:"POST",
                    url:"../../../controller/controllerRisorse.php",
                    data:{
                        operazione:"stampaImmaginiCartellaAltro",
                        immaginePartenza:0,
                        numeroImmagini:18
                    },
                    success:function(codice) {
                        document.getElementById("divSelezioneFoto").innerHTML = codice;
                        $('#modal-seleziona-foto').modal('show');
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
            
            function cambiaImmagineInEvidenzaDaPopup(percorso) {
                $.ajax({
                    type:"POST",
                    url:"controller/controllerComponente.php",
                    data:{
                        operazione:"modificaImmagineOccorrenzaConPercorso",
                        id:<?php echo $invitoAzione->getId() ?>,
                        percorso:percorso
                    },
                    success:function(risposta) {
                        if(risposta=="ok") {
                            document.getElementById("immagineElemento").src = "../../../"+percorso;
                        }
                        else {
                            alert(risposta);
                        }
                    }
                });
                $('#modal-seleziona-foto').modal('hide');
            }
            
            function aggiungiImmaginiModalSelezioneImmagini(immaginePartenza,numeroImmagini) {
                $.ajax({
                    type:"POST",
                    url:"../../../controller/controllerRisorse.php",
                    data:{
                        operazione:"stampaImmaginiCartellaAltro",
                        id:<?php echo $invitoAzione->getId() ?>,
                        immaginePartenza:immaginePartenza,
                        numeroImmagini:numeroImmagini
                    },
                    success:function(codice) {
                        var vecchioCodice = document.getElementById("divSelezioneFoto").innerHTML; 
                        document.getElementById("divSelezioneFoto").innerHTML = vecchioCodice+codice;
                        
                        // aggiorno i dati del pulsante
                        var nuovaImmagineDiPartenza = immaginePartenza+numeroImmagini;
                        document.getElementById("divBottoneModalSelezionaFoto").innerHTML = '<button type="button" class="btn btn-outline-primary" onclick="aggiungiImmaginiModalSelezioneImmagini('+nuovaImmagineDiPartenza+','+numeroImmagini+')">Mostra altre immagini</button>';
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
        </script>
    </body>
</html>
